/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.data.loader;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.spark.broadcast.Broadcast;
import org.datavec.spark.util.DefaultHadoopConfig;
import org.datavec.spark.util.SerializableHadoopConfig;
import org.deeplearning4j.spark.data.loader.RemoteFileSource;
import org.nd4j.api.loader.Source;
import org.nd4j.api.loader.SourceFactory;

public class RemoteFileSourceFactory
implements SourceFactory {
    private transient FileSystem fileSystem;
    private final Broadcast<SerializableHadoopConfig> conf;

    public RemoteFileSourceFactory(Broadcast<SerializableHadoopConfig> configuration) {
        this.conf = configuration;
    }

    public Source getSource(String path) {
        if (this.fileSystem == null) {
            Configuration c = this.conf == null ? DefaultHadoopConfig.get() : ((SerializableHadoopConfig)this.conf.getValue()).getConfiguration();
            try {
                this.fileSystem = FileSystem.get((URI)new URI(path), (Configuration)c);
            }
            catch (IOException | URISyntaxException u) {
                throw new RuntimeException(u);
            }
        }
        return new RemoteFileSource(path, this.fileSystem);
    }
}

