/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.earlystopping;

import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.deeplearning4j.earlystopping.EarlyStoppingConfiguration;
import org.deeplearning4j.earlystopping.EarlyStoppingResult;
import org.deeplearning4j.earlystopping.listener.EarlyStoppingListener;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.spark.api.TrainingMaster;
import org.deeplearning4j.spark.earlystopping.BaseSparkEarlyStoppingTrainer;
import org.deeplearning4j.spark.impl.graph.SparkComputationGraph;
import org.deeplearning4j.spark.impl.graph.dataset.DataSetToMultiDataSetFn;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.dataset.api.MultiDataSet;

public class SparkEarlyStoppingGraphTrainer
extends BaseSparkEarlyStoppingTrainer<ComputationGraph> {
    private SparkComputationGraph sparkNet;

    public SparkEarlyStoppingGraphTrainer(SparkContext sc, TrainingMaster trainingMaster, EarlyStoppingConfiguration<ComputationGraph> esConfig, ComputationGraph net, JavaRDD<MultiDataSet> train, int examplesPerFit, int totalExamples) {
        this(new JavaSparkContext(sc), trainingMaster, esConfig, net, train, null);
    }

    public SparkEarlyStoppingGraphTrainer(JavaSparkContext sc, TrainingMaster trainingMaster, EarlyStoppingConfiguration<ComputationGraph> esConfig, ComputationGraph net, JavaRDD<MultiDataSet> train, int examplesPerFit, int totalExamples) {
        this(sc, trainingMaster, esConfig, net, train, null);
    }

    public SparkEarlyStoppingGraphTrainer(SparkContext sc, TrainingMaster trainingMaster, EarlyStoppingConfiguration<ComputationGraph> esConfig, ComputationGraph net, JavaRDD<MultiDataSet> train) {
        this(new JavaSparkContext(sc), trainingMaster, esConfig, net, train, null);
    }

    public SparkEarlyStoppingGraphTrainer(JavaSparkContext sc, TrainingMaster trainingMaster, EarlyStoppingConfiguration<ComputationGraph> esConfig, ComputationGraph net, JavaRDD<MultiDataSet> train) {
        this(sc, trainingMaster, esConfig, net, train, null);
    }

    public SparkEarlyStoppingGraphTrainer(JavaSparkContext sc, TrainingMaster trainingMaster, EarlyStoppingConfiguration<ComputationGraph> esConfig, ComputationGraph net, JavaRDD<MultiDataSet> train, EarlyStoppingListener<ComputationGraph> listener) {
        super(sc, esConfig, net, null, train, listener);
        this.sparkNet = new SparkComputationGraph(sc, net, trainingMaster);
    }

    @Override
    protected void fit(JavaRDD<DataSet> data) {
        this.fitMulti((JavaRDD<MultiDataSet>)data.map((Function)new DataSetToMultiDataSetFn()));
    }

    @Override
    protected void fitMulti(JavaRDD<MultiDataSet> data) {
        this.sparkNet.fitMultiDataSet(data);
    }

    @Override
    protected double getScore() {
        return this.sparkNet.getScore();
    }

    public EarlyStoppingResult<ComputationGraph> pretrain() {
        throw new UnsupportedOperationException("Not supported");
    }
}

