/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.impl.graph.evaluation;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.Future;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.broadcast.Broadcast;
import org.datavec.spark.util.SerializableHadoopConfig;
import org.deeplearning4j.api.loader.DataSetLoader;
import org.deeplearning4j.api.loader.MultiDataSetLoader;
import org.deeplearning4j.datasets.iterator.impl.MultiDataSetIteratorAdapter;
import org.deeplearning4j.datasets.iterator.loader.DataSetLoaderIterator;
import org.deeplearning4j.datasets.iterator.loader.MultiDataSetLoaderIterator;
import org.deeplearning4j.spark.data.loader.RemoteFileSourceFactory;
import org.deeplearning4j.spark.impl.evaluation.EvaluationRunner;
import org.nd4j.api.loader.Loader;
import org.nd4j.api.loader.SourceFactory;
import org.nd4j.evaluation.IEvaluation;
import org.nd4j.linalg.dataset.api.MultiDataSet;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;

public class IEvaluateMDSPathsFlatMapFunction
implements FlatMapFunction<Iterator<String>, IEvaluation[]> {
    protected Broadcast<String> json;
    protected Broadcast<byte[]> params;
    protected int evalNumWorkers;
    protected int evalBatchSize;
    protected DataSetLoader dsLoader;
    protected MultiDataSetLoader mdsLoader;
    protected Broadcast<SerializableHadoopConfig> conf;
    protected IEvaluation[] evaluations;

    public IEvaluateMDSPathsFlatMapFunction(Broadcast<String> json, Broadcast<byte[]> params, int evalNumWorkers, int evalBatchSize, DataSetLoader dsLoader, MultiDataSetLoader mdsLoader, Broadcast<SerializableHadoopConfig> configuration, IEvaluation[] evaluations) {
        this.json = json;
        this.params = params;
        this.evalNumWorkers = evalNumWorkers;
        this.evalBatchSize = evalBatchSize;
        this.dsLoader = dsLoader;
        this.mdsLoader = mdsLoader;
        this.conf = configuration;
        this.evaluations = evaluations;
    }

    public Iterator<IEvaluation[]> call(Iterator<String> paths) throws Exception {
        MultiDataSetLoaderIterator iter;
        if (!paths.hasNext()) {
            return Collections.emptyIterator();
        }
        if (this.dsLoader != null) {
            DataSetLoaderIterator dsIter = new DataSetLoaderIterator(paths, (Loader)this.dsLoader, (SourceFactory)new RemoteFileSourceFactory(this.conf));
            iter = new MultiDataSetIteratorAdapter((DataSetIterator)dsIter);
        } else {
            iter = new MultiDataSetLoaderIterator(paths, (Loader)this.mdsLoader, (SourceFactory)new RemoteFileSourceFactory(this.conf));
        }
        Future<IEvaluation[]> f = EvaluationRunner.getInstance().execute(this.evaluations, this.evalNumWorkers, this.evalBatchSize, null, (Iterator<MultiDataSet>)iter, true, this.json, this.params);
        IEvaluation[] result = f.get();
        if (result == null) {
            return Collections.emptyIterator();
        }
        return Collections.singletonList(result).iterator();
    }
}

