/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.malmo;

import com.microsoft.msr.malmo.AgentHost;
import com.microsoft.msr.malmo.ClientInfo;
import com.microsoft.msr.malmo.ClientPool;
import com.microsoft.msr.malmo.MissionRecordSpec;
import com.microsoft.msr.malmo.MissionSpec;
import com.microsoft.msr.malmo.TimestampedReward;
import com.microsoft.msr.malmo.WorldState;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.deeplearning4j.gym.StepReply;
import org.deeplearning4j.malmo.MalmoActionSpace;
import org.deeplearning4j.malmo.MalmoBox;
import org.deeplearning4j.malmo.MalmoConnectionError;
import org.deeplearning4j.malmo.MalmoObservationPolicy;
import org.deeplearning4j.malmo.MalmoObservationSpace;
import org.deeplearning4j.malmo.MalmoResetHandler;
import org.deeplearning4j.rl4j.mdp.MDP;
import org.deeplearning4j.rl4j.space.DiscreteSpace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MalmoEnv
implements MDP<MalmoBox, Integer, DiscreteSpace> {
    private static final int NUM_RETRIES = 10;
    private final Logger logger;
    MissionSpec mission = null;
    MissionRecordSpec missionRecord = null;
    ClientPool clientPool = null;
    MalmoObservationSpace observationSpace;
    MalmoActionSpace actionSpace;
    MalmoObservationPolicy framePolicy;
    AgentHost agent_host = null;
    WorldState last_world_state;
    MalmoBox last_observation;
    MalmoResetHandler resetHandler = null;

    public MalmoEnv(String missionFileName, MalmoActionSpace actionSpace, MalmoObservationSpace observationSpace, MalmoObservationPolicy framePolicy, String ... clientPool) {
        this(MalmoEnv.loadMissionXML(missionFileName), null, actionSpace, observationSpace, framePolicy, null);
        if (clientPool == null || clientPool.length == 0) {
            clientPool = new String[]{"127.0.0.1:10000"};
        }
        this.clientPool = new ClientPool();
        for (String client : clientPool) {
            String[] parts = client.split(":");
            this.clientPool.add(new ClientInfo(parts[0], (int)Short.parseShort(parts[1])));
        }
    }

    public MalmoEnv(MissionSpec mission, MissionRecordSpec missionRecord, MalmoActionSpace actionSpace, MalmoObservationSpace observationSpace, MalmoObservationPolicy framePolicy, ClientPool clientPool) {
        this.mission = mission;
        this.missionRecord = missionRecord != null ? missionRecord : new MissionRecordSpec();
        this.actionSpace = actionSpace;
        this.observationSpace = observationSpace;
        this.framePolicy = framePolicy;
        this.clientPool = clientPool;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public static MissionSpec loadMissionXML(String filename) {
        MissionSpec mission = null;
        try {
            String xml = new String(Files.readAllBytes(Paths.get(filename, new String[0])));
            mission = new MissionSpec(xml, true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return mission;
    }

    public MalmoBox reset() {
        int i;
        this.close();
        if (this.resetHandler != null) {
            this.resetHandler.onReset(this);
        }
        this.agent_host = new AgentHost();
        for (i = 9; i > 0; --i) {
            try {
                Thread.sleep(100 + 500 * (10 - i - 1));
                this.agent_host.startMission(this.mission, this.clientPool, this.missionRecord, 0, "rl4j_0");
                break;
            }
            catch (Exception e) {
                this.logger.warn("Error starting mission: " + e.getMessage() + " Retrying " + i + " more times.");
                continue;
            }
        }
        if (i == 0) {
            this.close();
            throw new MalmoConnectionError("Unable to connect to client.");
        }
        this.logger.info("Waiting for the mission to start");
        do {
            this.last_world_state = this.agent_host.getWorldState();
        } while (!this.last_world_state.getIsMissionRunning());
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.last_world_state = this.waitForObservations(false);
        this.last_observation = this.observationSpace.getObservation(this.last_world_state);
        return this.last_observation;
    }

    private WorldState waitForObservations(boolean andRewards) {
        WorldState world_state;
        boolean missingData;
        WorldState original_world_state = this.last_world_state;
        do {
            boolean bl;
            Thread.yield();
            world_state = this.agent_host.peekWorldState();
            boolean bl2 = missingData = world_state.getObservations().isEmpty() || world_state.getVideoFrames().isEmpty();
            if (andRewards) {
                if (missingData || !this.framePolicy.isObservationConsistant(world_state, original_world_state)) {
                    bl = true;
                    continue;
                }
                bl = false;
                continue;
            }
            bl = missingData = missingData;
        } while (missingData && world_state.getIsMissionRunning());
        return this.agent_host.getWorldState();
    }

    public void close() {
        if (this.agent_host != null) {
            this.agent_host.delete();
        }
        this.agent_host = null;
    }

    public StepReply<MalmoBox> step(Integer action) {
        this.agent_host.sendCommand((String)this.actionSpace.encode(action));
        this.last_world_state = this.waitForObservations(true);
        this.last_observation = this.observationSpace.getObservation(this.last_world_state);
        if (this.isDone()) {
            this.logger.info("Mission ended");
        }
        return new StepReply((Object)this.last_observation, this.getRewards(this.last_world_state), this.isDone(), null);
    }

    private double getRewards(WorldState world_state) {
        double rval = 0.0;
        int i = 0;
        while ((long)i < world_state.getRewards().size()) {
            TimestampedReward reward = world_state.getRewards().get(i);
            rval += reward.getValue();
            ++i;
        }
        return rval;
    }

    public boolean isDone() {
        return !this.last_world_state.getIsMissionRunning();
    }

    public MDP<MalmoBox, Integer, DiscreteSpace> newInstance() {
        MalmoEnv rval = new MalmoEnv(this.mission, this.missionRecord, this.actionSpace, this.observationSpace, this.framePolicy, this.clientPool);
        rval.setResetHandler(this.resetHandler);
        return rval;
    }

    public void setMission(MissionSpec mission) {
        this.mission = mission;
    }

    public MalmoObservationSpace getObservationSpace() {
        return this.observationSpace;
    }

    public MalmoActionSpace getActionSpace() {
        return this.actionSpace;
    }

    public void setResetHandler(MalmoResetHandler resetHandler) {
        this.resetHandler = resetHandler;
    }

    static {
        String malmoHome = System.getenv("MALMO_HOME");
        if (malmoHome == null) {
            throw new RuntimeException("MALMO_HOME must be set to your Malmo environement.");
        }
        try {
            if (Files.exists(Paths.get(malmoHome + "/Java_Examples/libMalmoJava.jnilib", new String[0]), new LinkOption[0])) {
                System.load(malmoHome + "/Java_Examples/libMalmoJava.jnilib");
            } else if (Files.exists(Paths.get(malmoHome + "/Java_Examples/MalmoJava.dll", new String[0]), new LinkOption[0])) {
                System.load(malmoHome + "/Java_Examples/MalmoJava.dll");
            } else if (Files.exists(Paths.get(malmoHome + "/Java_Examples/libMalmoJava.so", new String[0]), new LinkOption[0])) {
                System.load(malmoHome + "/Java_Examples/libMalmoJava.so");
            } else {
                System.load("MalmoJava");
            }
        }
        catch (UnsatisfiedLinkError e) {
            throw new RuntimeException("MALMO_HOME must be set to your Malmo environement. Could not load native library at '" + malmoHome + "/Java_Examples/'", e);
        }
    }
}

