/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.malmo;

import com.microsoft.msr.malmo.TimestampedStringVector;
import com.microsoft.msr.malmo.WorldState;
import java.util.HashMap;
import org.deeplearning4j.malmo.MalmoBox;
import org.deeplearning4j.malmo.MalmoObservationSpace;
import org.json.JSONArray;
import org.json.JSONObject;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class MalmoObservationSpaceGrid
extends MalmoObservationSpace {
    static final int MAX_BLOCK = 4095;
    int size;
    String name;
    int totalSize;
    HashMap<String, Integer> blockMap = new HashMap();

    public MalmoObservationSpaceGrid(String name, int xSize, int ySize, int zSize, Object ... blocks) {
        this.name = name;
        this.totalSize = xSize * ySize * zSize;
        if (blocks.length == 0) {
            this.size = 4095;
        } else {
            this.size = blocks.length;
            for (int i = 0; i < blocks.length; ++i) {
                if (blocks[i] instanceof String) {
                    this.blockMap.put((String)blocks[i], i + 1);
                    continue;
                }
                for (String block : (String[])blocks[i]) {
                    this.blockMap.put(block, i + 1);
                }
            }
        }
    }

    public String getName() {
        return "Box(" + this.totalSize + ")";
    }

    public int[] getShape() {
        return new int[]{this.totalSize};
    }

    public INDArray getLow() {
        INDArray low = Nd4j.create((int[])this.getShape());
        return low;
    }

    public INDArray getHigh() {
        INDArray high = Nd4j.linspace((long)255L, (long)255L, (long)this.totalSize).reshape(this.getShape());
        return high;
    }

    @Override
    public MalmoBox getObservation(WorldState world_state) {
        TimestampedStringVector observations = world_state.getObservations();
        if (observations.isEmpty()) {
            return null;
        }
        String obs_text = observations.get((int)(observations.size() - 1L)).getText();
        JSONObject observation = new JSONObject(obs_text);
        JSONArray blocks = observation.getJSONArray(this.name);
        double[] blockTypes = new double[this.totalSize];
        for (int i = 0; i < this.totalSize; ++i) {
            String block = blocks.getString(i);
            Integer mapped = this.blockMap.get(block);
            if (this.size == 4095 && mapped == null) {
                mapped = this.blockMap.size();
                this.blockMap.put(block, mapped);
            }
            blockTypes[i] = mapped == null ? 0.0 : (double)mapped.intValue();
        }
        return new MalmoBox(blockTypes);
    }
}

