/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.malmo;

import com.microsoft.msr.malmo.ByteVector;
import com.microsoft.msr.malmo.TimestampedVideoFrameVector;
import com.microsoft.msr.malmo.WorldState;
import java.util.HashMap;
import org.deeplearning4j.malmo.MalmoBox;
import org.deeplearning4j.malmo.MalmoObservationSpace;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class MalmoObservationSpacePixels
extends MalmoObservationSpace {
    int xSize;
    int ySize;
    HashMap<String, Integer> blockMap = new HashMap();

    public MalmoObservationSpacePixels(int xSize, int ySize) {
        this.xSize = xSize;
        this.ySize = ySize;
    }

    public String getName() {
        return "Box(" + this.ySize + "," + this.xSize + ",3)";
    }

    public int[] getShape() {
        return new int[]{this.ySize, this.xSize, 3};
    }

    public INDArray getLow() {
        INDArray low = Nd4j.create((int[])this.getShape());
        return low;
    }

    public INDArray getHigh() {
        INDArray high = Nd4j.linspace((long)255L, (long)255L, (long)(this.xSize * this.ySize * 3)).reshape(this.getShape());
        return high;
    }

    @Override
    public MalmoBox getObservation(WorldState world_state) {
        TimestampedVideoFrameVector observations = world_state.getVideoFrames();
        double[] rawPixels = new double[this.xSize * this.ySize * 3];
        if (!observations.isEmpty()) {
            ByteVector pixels = observations.get((int)(observations.size() - 1L)).getPixels();
            int i = 0;
            for (int x = 0; x < this.xSize; ++x) {
                for (int y = 0; y < this.ySize; ++y) {
                    for (int c = 2; c >= 0; --c) {
                        rawPixels[i] = (double)pixels.get(3 * x * this.ySize + y * 3 + c) / 255.0;
                        ++i;
                    }
                }
            }
        }
        return new MalmoBox(rawPixels);
    }
}

