/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.malmo;

import com.microsoft.msr.malmo.TimestampedStringVector;
import com.microsoft.msr.malmo.WorldState;
import org.deeplearning4j.malmo.MalmoBox;
import org.deeplearning4j.malmo.MalmoObservationSpace;
import org.json.JSONObject;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class MalmoObservationSpacePosition
extends MalmoObservationSpace {
    public String getName() {
        return "Box(5,)";
    }

    public int[] getShape() {
        return new int[]{5};
    }

    public INDArray getLow() {
        INDArray low = Nd4j.create((float[])new float[]{-2.1474836E9f, -2.1474836E9f, -2.1474836E9f});
        return low;
    }

    public INDArray getHigh() {
        INDArray high = Nd4j.create((float[])new float[]{2.1474836E9f, 2.1474836E9f, 2.1474836E9f});
        return high;
    }

    @Override
    public MalmoBox getObservation(WorldState world_state) {
        TimestampedStringVector observations = world_state.getObservations();
        if (observations.isEmpty()) {
            return null;
        }
        String obs_text = observations.get((int)(observations.size() - 1L)).getText();
        JSONObject observation = new JSONObject(obs_text);
        double xpos = observation.getDouble("XPos");
        double ypos = observation.getDouble("YPos");
        double zpos = observation.getDouble("ZPos");
        double yaw = observation.getDouble("Yaw");
        double pitch = observation.getDouble("Pitch");
        return new MalmoBox(xpos, ypos, zpos, yaw, pitch);
    }
}

