/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;

public class Locks {
    public static <L extends Lock> void lockAll(L ... locks) {
        LinkedList<L> stack = new LinkedList<L>();
        try {
            for (L lock : locks) {
                lock.lock();
                stack.push(lock);
            }
        }
        catch (RuntimeException rex) {
            Locks.unlockAll(stack);
            throw rex;
        }
    }

    public static <L extends Lock> void lockInterruptiblyAll(L ... locks) throws InterruptedException {
        LinkedList<L> stack = new LinkedList<L>();
        try {
            for (L lock : locks) {
                lock.lockInterruptibly();
                stack.push(lock);
            }
        }
        catch (InterruptedException | RuntimeException e) {
            Locks.unlockAll(stack);
            throw e;
        }
    }

    public static <L extends Lock> boolean tryLockAll(L ... locks) {
        LinkedList<L> stack = new LinkedList<L>();
        boolean success = false;
        try {
            L lock;
            L[] arr$ = locks;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (success = (lock = arr$[i$]).tryLock()); ++i$) {
                stack.push(lock);
            }
        }
        catch (RuntimeException e) {
            Locks.unlockAll(stack);
            throw e;
        }
        if (!success) {
            Locks.unlockAll(stack);
        }
        return success;
    }

    public static <L extends Lock> boolean tryLockAll(long time, TimeUnit unit, L ... locks) throws InterruptedException {
        LinkedList<L> stack = new LinkedList<L>();
        boolean success = false;
        try {
            long remainingNanos;
            L lock;
            long limitNanos = unit.toNanos(time);
            long startNanos = System.nanoTime();
            L[] arr$ = locks;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (success = (lock = arr$[i$]).tryLock(remainingNanos = !success ? limitNanos : limitNanos - (System.nanoTime() - startNanos), TimeUnit.NANOSECONDS)); ++i$) {
                stack.push(lock);
            }
        }
        catch (InterruptedException | RuntimeException e) {
            Locks.unlockAll(stack);
            throw e;
        }
        if (!success) {
            Locks.unlockAll(stack);
        }
        return success;
    }

    public static <L extends Lock> void unlockAll(L ... locks) {
        for (L lock : locks) {
            lock.unlock();
        }
    }

    public static <L extends Lock> void unlockAll(Collection<L> locks) {
        for (Lock lock : locks) {
            lock.unlock();
        }
    }
}

