/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.beans.ConstructorProperties;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.jooq.Attachable;
import org.jooq.AttachableInternal;
import org.jooq.Configuration;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.RecordMapper;
import org.jooq.RecordType;
import org.jooq.exception.MappingException;
import org.jooq.impl.AbstractRecord;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultDataType;
import org.jooq.impl.Fields;
import org.jooq.impl.Tools;
import org.jooq.tools.Convert;
import org.jooq.tools.StringUtils;
import org.jooq.tools.reflect.Reflect;

public class DefaultRecordMapper<R extends Record, E>
implements RecordMapper<R, E> {
    private final Field<?>[] fields;
    private final RecordType<R> rowType;
    private final Class<? extends E> type;
    private final Configuration configuration;
    private RecordMapper<R, E> delegate;

    public DefaultRecordMapper(RecordType<R> rowType, Class<? extends E> type) {
        this(rowType, type, null, null);
    }

    DefaultRecordMapper(RecordType<R> rowType, Class<? extends E> type, Configuration configuration) {
        this(rowType, type, null, configuration);
    }

    DefaultRecordMapper(RecordType<R> rowType, Class<? extends E> type, E instance) {
        this(rowType, type, (E)instance, null);
    }

    DefaultRecordMapper(RecordType<R> rowType, Class<? extends E> type, E instance, Configuration configuration) {
        this.rowType = rowType;
        this.fields = rowType.fields();
        this.type = type;
        this.configuration = configuration;
        this.init(instance);
    }

    private final void init(E instance) {
        if (this.type.isArray()) {
            this.delegate = new ArrayMapper(instance);
            return;
        }
        if (Stream.class.isAssignableFrom(this.type)) {
            DefaultRecordMapper local = new DefaultRecordMapper(this.rowType, (Class<Configuration>)Object[].class, this.configuration);
            this.delegate = r -> Stream.of((Object[])local.map(r));
            return;
        }
        if (this.type.isPrimitive() || DefaultDataType.types().contains(this.type) || Enum.class.isAssignableFrom(this.type)) {
            this.delegate = new ValueTypeMapper();
            return;
        }
        if (Modifier.isAbstract(this.type.getModifiers())) {
            this.delegate = new ProxyMapper();
            return;
        }
        if (AbstractRecord.class.isAssignableFrom(this.type)) {
            this.delegate = new RecordToRecordMapper();
            return;
        }
        try {
            this.delegate = new MutablePOJOMapper(this.type.getDeclaredConstructor(new Class[0]), instance);
            return;
        }
        catch (NoSuchMethodException local) {
            Constructor<?>[] constructors;
            for (Constructor<?> constructor : constructors = this.type.getDeclaredConstructors()) {
                ConstructorProperties properties = constructor.getAnnotation(ConstructorProperties.class);
                if (properties == null) continue;
                this.delegate = new ImmutablePOJOMapperWithConstructorProperties(constructor, properties);
                return;
            }
            for (Constructor<?> constructor : constructors) {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (parameterTypes.length != this.fields.length) continue;
                this.delegate = new ImmutablePOJOMapper(constructor, parameterTypes);
                return;
            }
            throw new MappingException("No matching constructor found on type " + this.type + " for record " + this);
        }
    }

    @Override
    public final E map(R record) {
        if (record == null) {
            return null;
        }
        try {
            return DefaultRecordMapper.attach(this.delegate.map(record), record);
        }
        catch (MappingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MappingException("An error ocurred when mapping record to " + this.type, e);
        }
    }

    private static <E> E attach(E attachable, Record record) {
        if (attachable instanceof Attachable && record instanceof AttachableInternal) {
            Attachable a = (Attachable)attachable;
            AttachableInternal r = (AttachableInternal)((Object)record);
            if (Tools.attachRecords(r.configuration())) {
                a.attach(r.configuration());
            }
        }
        return attachable;
    }

    private class ImmutablePOJOMapperWithConstructorProperties
    implements RecordMapper<R, E> {
        private final Constructor<E> constructor;
        private final Class<?>[] parameterTypes;
        private final Object[] parameterValues;
        private final List<String> propertyNames;
        private final boolean useAnnotations;
        private final List<java.lang.reflect.Field>[] members;
        private final Method[] methods;
        private final Integer[] propertyIndexes;

        ImmutablePOJOMapperWithConstructorProperties(Constructor<E> constructor, ConstructorProperties properties) {
            this.constructor = constructor;
            this.propertyNames = Arrays.asList(properties.value());
            this.useAnnotations = Tools.hasColumnAnnotations(DefaultRecordMapper.this.configuration, DefaultRecordMapper.this.type);
            this.parameterTypes = constructor.getParameterTypes();
            this.parameterValues = new Object[this.parameterTypes.length];
            this.members = new List[DefaultRecordMapper.this.fields.length];
            this.methods = new Method[DefaultRecordMapper.this.fields.length];
            this.propertyIndexes = new Integer[DefaultRecordMapper.this.fields.length];
            block0: for (int i = 0; i < DefaultRecordMapper.this.fields.length; ++i) {
                Field field = DefaultRecordMapper.this.fields[i];
                String name = field.getName();
                String nameLC = StringUtils.toCamelCaseLC(name);
                if (this.useAnnotations) {
                    this.members[i] = Tools.getAnnotatedMembers(DefaultRecordMapper.this.configuration, DefaultRecordMapper.this.type, name);
                    this.methods[i] = Tools.getAnnotatedGetter(DefaultRecordMapper.this.configuration, DefaultRecordMapper.this.type, name);
                } else {
                    this.members[i] = Tools.getMatchingMembers(DefaultRecordMapper.this.configuration, DefaultRecordMapper.this.type, name);
                    this.methods[i] = Tools.getMatchingGetter(DefaultRecordMapper.this.configuration, DefaultRecordMapper.this.type, name);
                }
                for (int j = 0; j < this.propertyNames.size(); ++j) {
                    if (!name.equals(this.propertyNames.get(j)) && !nameLC.equals(this.propertyNames.get(j))) continue;
                    this.propertyIndexes[i] = j;
                    continue block0;
                }
            }
        }

        @Override
        public final E map(R record) {
            try {
                for (int i = 0; i < DefaultRecordMapper.this.fields.length; ++i) {
                    String name;
                    int index;
                    if (this.propertyIndexes[i] != null) {
                        this.parameterValues[this.propertyIndexes[i].intValue()] = record.get(i);
                        continue;
                    }
                    for (java.lang.reflect.Field member : this.members[i]) {
                        int index2 = this.propertyNames.indexOf(member.getName());
                        if (index2 < 0) continue;
                        this.parameterValues[index2] = record.get(i);
                    }
                    if (this.methods[i] == null || (index = this.propertyNames.indexOf(name = Tools.getPropertyName(this.methods[i].getName()))) < 0) continue;
                    this.parameterValues[index] = record.get(i);
                }
                Object[] converted = Convert.convert(this.parameterValues, this.parameterTypes);
                return Reflect.accessible(this.constructor).newInstance(converted);
            }
            catch (Exception e) {
                throw new MappingException("An error ocurred when mapping record to " + DefaultRecordMapper.this.type, e);
            }
        }
    }

    private class ImmutablePOJOMapper
    implements RecordMapper<R, E> {
        private final Constructor<E> constructor;
        private final Class<?>[] parameterTypes;

        public ImmutablePOJOMapper(Constructor<E> constructor, Class<?>[] parameterTypes) {
            this.constructor = Reflect.accessible(constructor);
            this.parameterTypes = parameterTypes;
        }

        @Override
        public final E map(R record) {
            try {
                Object[] converted = Convert.convert(record.intoArray(), this.parameterTypes);
                return this.constructor.newInstance(converted);
            }
            catch (Exception e) {
                throw new MappingException("An error ocurred when mapping record to " + DefaultRecordMapper.this.type, e);
            }
        }
    }

    private class MutablePOJOMapper
    implements RecordMapper<R, E> {
        private final Constructor<? extends E> constructor;
        private final boolean useAnnotations;
        private final List<java.lang.reflect.Field>[] members;
        private final List<Method>[] methods;
        private final Map<String, List<RecordMapper<R, Object>>> nested;
        private final E instance;

        MutablePOJOMapper(Constructor<? extends E> constructor, E instance) {
            this.constructor = Reflect.accessible(constructor);
            this.useAnnotations = Tools.hasColumnAnnotations(DefaultRecordMapper.this.configuration, DefaultRecordMapper.this.type);
            this.members = new List[DefaultRecordMapper.this.fields.length];
            this.methods = new List[DefaultRecordMapper.this.fields.length];
            this.nested = new HashMap();
            this.instance = instance;
            HashMap<String, Field[]> nestedFields = new HashMap<String, Field[]>();
            for (int i = 0; i < DefaultRecordMapper.this.fields.length; ++i) {
                Field field = DefaultRecordMapper.this.fields[i];
                String name = field.getName();
                if (this.useAnnotations) {
                    this.members[i] = Tools.getAnnotatedMembers(DefaultRecordMapper.this.configuration, DefaultRecordMapper.this.type, name);
                    this.methods[i] = Tools.getAnnotatedSetters(DefaultRecordMapper.this.configuration, DefaultRecordMapper.this.type, name);
                    continue;
                }
                int dot = name.indexOf(46);
                if (dot > -1) {
                    String prefix = name.substring(0, dot);
                    Field[] f = (Field[])nestedFields.get(prefix);
                    if (f == null) {
                        f = Collections.nCopies(DefaultRecordMapper.this.fields.length, DSL.field("")).toArray(Tools.EMPTY_FIELD);
                        nestedFields.put(prefix, f);
                    }
                    f[i] = DSL.field(DSL.name(name.substring(prefix.length() + 1)), field.getDataType());
                    this.members[i] = Collections.emptyList();
                    this.methods[i] = Collections.emptyList();
                    continue;
                }
                this.members[i] = Tools.getMatchingMembers(DefaultRecordMapper.this.configuration, DefaultRecordMapper.this.type, name);
                this.methods[i] = Tools.getMatchingSetters(DefaultRecordMapper.this.configuration, DefaultRecordMapper.this.type, name);
            }
            for (Map.Entry entry : nestedFields.entrySet()) {
                String prefix = (String)entry.getKey();
                ArrayList<RemovingPrefixRecordMapper> list = new ArrayList<RemovingPrefixRecordMapper>();
                for (java.lang.reflect.Field member : Tools.getMatchingMembers(DefaultRecordMapper.this.configuration, DefaultRecordMapper.this.type, prefix)) {
                    list.add(new RemovingPrefixRecordMapper(new DefaultRecordMapper(new Fields((Field[])entry.getValue()), member.getType(), null, DefaultRecordMapper.this.configuration), DefaultRecordMapper.this.fields, prefix));
                }
                for (Method method : Tools.getMatchingSetters(DefaultRecordMapper.this.configuration, DefaultRecordMapper.this.type, prefix)) {
                    list.add(new RemovingPrefixRecordMapper(new DefaultRecordMapper(new Fields((Field[])entry.getValue()), method.getParameterTypes()[0], null, DefaultRecordMapper.this.configuration), DefaultRecordMapper.this.fields, prefix));
                }
                this.nested.put(prefix, list);
            }
        }

        @Override
        public final E map(R record) {
            try {
                Object result = this.instance != null ? this.instance : this.constructor.newInstance(new Object[0]);
                for (int i = 0; i < DefaultRecordMapper.this.fields.length; ++i) {
                    for (java.lang.reflect.Field member : this.members[i]) {
                        if ((member.getModifiers() & 0x10) != 0) continue;
                        this.map((Record)record, result, member, i);
                    }
                    for (Method method : this.methods[i]) {
                        Class<?> mType = method.getParameterTypes()[0];
                        Object value = record.get(i, mType);
                        if (value instanceof Collection && List.class.isAssignableFrom(mType)) {
                            Class componentType = (Class)((ParameterizedType)method.getGenericParameterTypes()[0]).getActualTypeArguments()[0];
                            method.invoke(result, Convert.convert((Collection)value, componentType));
                            continue;
                        }
                        method.invoke(result, record.get(i, mType));
                    }
                }
                for (Map.Entry entry : this.nested.entrySet()) {
                    String prefix = entry.getKey();
                    for (RecordMapper mapper : entry.getValue()) {
                        Object value = mapper.map(record);
                        for (java.lang.reflect.Field member : Tools.getMatchingMembers(DefaultRecordMapper.this.configuration, DefaultRecordMapper.this.type, prefix)) {
                            if ((member.getModifiers() & 0x10) != 0) continue;
                            this.map(value, result, member);
                        }
                        for (Method method : Tools.getMatchingSetters(DefaultRecordMapper.this.configuration, DefaultRecordMapper.this.type, prefix)) {
                            method.invoke(result, value);
                        }
                    }
                }
                return result;
            }
            catch (Exception e) {
                throw new MappingException("An error ocurred when mapping record to " + DefaultRecordMapper.this.type, e);
            }
        }

        private final void map(Record record, Object result, java.lang.reflect.Field member, int index) throws IllegalAccessException {
            Class<?> mType = member.getType();
            if (mType.isPrimitive()) {
                if (mType == Byte.TYPE) {
                    this.map(record.get(index, Byte.TYPE), result, member);
                } else if (mType == Short.TYPE) {
                    this.map(record.get(index, Short.TYPE), result, member);
                } else if (mType == Integer.TYPE) {
                    this.map(record.get(index, Integer.TYPE), result, member);
                } else if (mType == Long.TYPE) {
                    this.map(record.get(index, Long.TYPE), result, member);
                } else if (mType == Float.TYPE) {
                    this.map(record.get(index, Float.TYPE), result, member);
                } else if (mType == Double.TYPE) {
                    this.map(record.get(index, Double.TYPE), result, member);
                } else if (mType == Boolean.TYPE) {
                    this.map(record.get(index, Boolean.TYPE), result, member);
                } else if (mType == Character.TYPE) {
                    this.map(record.get(index, Character.TYPE), result, member);
                }
            } else {
                Object value = record.get(index, mType);
                if (value instanceof Collection && List.class.isAssignableFrom(mType)) {
                    Class componentType = (Class)((ParameterizedType)member.getGenericType()).getActualTypeArguments()[0];
                    member.set(result, Convert.convert((Collection)value, componentType));
                } else {
                    this.map(value, result, member);
                }
            }
        }

        private final void map(Object value, Object result, java.lang.reflect.Field member) throws IllegalAccessException {
            Class<?> mType = member.getType();
            if (mType.isPrimitive()) {
                if (mType == Byte.TYPE) {
                    member.setByte(result, (Byte)value);
                } else if (mType == Short.TYPE) {
                    member.setShort(result, (Short)value);
                } else if (mType == Integer.TYPE) {
                    member.setInt(result, (Integer)value);
                } else if (mType == Long.TYPE) {
                    member.setLong(result, (Long)value);
                } else if (mType == Float.TYPE) {
                    member.setFloat(result, ((Float)value).floatValue());
                } else if (mType == Double.TYPE) {
                    member.setDouble(result, (Double)value);
                } else if (mType == Boolean.TYPE) {
                    member.setBoolean(result, (Boolean)value);
                } else if (mType == Character.TYPE) {
                    member.setChar(result, ((Character)value).charValue());
                }
            } else {
                member.set(result, value);
            }
        }
    }

    private class RemovingPrefixRecordMapper
    implements RecordMapper<R, Object> {
        private final RecordMapper<R, Object> d;
        private final Field<?>[] f;

        RemovingPrefixRecordMapper(RecordMapper<R, Object> d, Field<?>[] fields, String prefix) {
            this.d = d;
            this.f = new Field[fields.length];
            String dotted = prefix + ".";
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].getName().startsWith(dotted)) continue;
                this.f[i] = DSL.field(DSL.name(fields[i].getName().substring(dotted.length() + 1)), fields[i].getDataType());
            }
        }

        @Override
        public Object map(R record) {
            AbstractRecord copy = (AbstractRecord)DSL.using(DefaultRecordMapper.this.configuration).newRecord(this.f);
            for (int i = 0; i < this.f.length; ++i) {
                if (this.f[i] == null) continue;
                copy.set(i, record.get(i));
            }
            return this.d.map(record);
        }
    }

    private class RecordToRecordMapper
    implements RecordMapper<R, AbstractRecord> {
        private RecordToRecordMapper() {
        }

        @Override
        public final AbstractRecord map(R record) {
            try {
                if (record instanceof AbstractRecord) {
                    return (AbstractRecord)((AbstractRecord)record).intoRecord(DefaultRecordMapper.this.type);
                }
                throw new MappingException("Cannot map record " + record + " to type " + DefaultRecordMapper.this.type);
            }
            catch (Exception e) {
                throw new MappingException("An error ocurred when mapping record to " + DefaultRecordMapper.this.type, e);
            }
        }
    }

    private class ProxyMapper
    implements RecordMapper<R, E> {
        Constructor<MethodHandles.Lookup> constructor;

        private ProxyMapper() {
        }

        @Override
        public final E map(R record) {
            return new MutablePOJOMapper(null, this.proxy()).map(record);
        }

        private E proxy() {
            final Object[] result = new Object[1];
            final HashMap map = new HashMap();
            InvocationHandler handler = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) {
                    int length;
                    String name = method.getName();
                    int n = length = args == null ? 0 : args.length;
                    if (length == 0 && name.startsWith("get")) {
                        return map.get(name.substring(3));
                    }
                    if (length == 0 && name.startsWith("is")) {
                        return map.get(name.substring(2));
                    }
                    if (length == 1 && name.startsWith("set")) {
                        map.put(name.substring(3), args[0]);
                    } else if (method.isDefault()) {
                        try {
                            if (ProxyMapper.this.constructor == null) {
                                ProxyMapper.this.constructor = Reflect.accessible(MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE));
                            }
                            Class<?> declaringClass = method.getDeclaringClass();
                            return ProxyMapper.this.constructor.newInstance(declaringClass, 2).unreflectSpecial(method, declaringClass).bindTo(result[0]).invokeWithArguments(args);
                        }
                        catch (Throwable e) {
                            throw new MappingException("Cannot invoke default method", e);
                        }
                    }
                    return null;
                }
            };
            result[0] = Proxy.newProxyInstance(DefaultRecordMapper.this.type.getClassLoader(), new Class[]{DefaultRecordMapper.this.type}, handler);
            return result[0];
        }
    }

    private class ValueTypeMapper
    implements RecordMapper<R, E> {
        private ValueTypeMapper() {
        }

        @Override
        public final E map(R record) {
            int size = record.size();
            if (size != 1) {
                throw new MappingException("Cannot map multi-column record of degree " + size + " to value type " + DefaultRecordMapper.this.type);
            }
            return record.get(0, DefaultRecordMapper.this.type);
        }
    }

    private class ArrayMapper
    implements RecordMapper<R, E> {
        private final E instance;

        ArrayMapper(E instance) {
            this.instance = instance;
        }

        @Override
        public final E map(R record) {
            int size = record.size();
            Class<?> componentType = DefaultRecordMapper.this.type.getComponentType();
            Object[] result = (Object[])(this.instance != null ? this.instance : Array.newInstance(componentType, size));
            if (size > result.length) {
                result = (Object[])Array.newInstance(componentType, size);
            }
            for (int i = 0; i < size; ++i) {
                result[i] = Convert.convert(record.get(i), componentType);
            }
            return result;
        }
    }
}

