/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.DuplicateKeyException;
import com.mongodb.ErrorCategory;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoException;
import com.mongodb.MongoExecutionTimeoutException;
import com.mongodb.MongoNodeIsRecoveringException;
import com.mongodb.MongoNotPrimaryException;
import com.mongodb.MongoQueryException;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcernException;
import com.mongodb.WriteConcernResult;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.MessageSettings;
import com.mongodb.connection.RequestMessage;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import com.mongodb.event.CommandFailedEvent;
import com.mongodb.event.CommandListener;
import com.mongodb.event.CommandStartedEvent;
import com.mongodb.event.CommandSucceededEvent;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonNumber;
import org.bson.BsonReader;
import org.bson.BsonString;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.io.BsonOutput;

final class ProtocolHelper {
    private static final Logger PROTOCOL_EVENT_LOGGER = Loggers.getLogger("protocol.event");
    private static final CodecRegistry REGISTRY = CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{new BsonValueCodecProvider()});

    static WriteConcernResult getWriteResult(BsonDocument result, ServerAddress serverAddress) {
        if (!ProtocolHelper.isCommandOk(result)) {
            throw ProtocolHelper.getCommandFailureException(result, serverAddress);
        }
        if (ProtocolHelper.hasWriteError(result)) {
            ProtocolHelper.throwWriteException(result, serverAddress);
        }
        return ProtocolHelper.createWriteResult(result);
    }

    private static WriteConcernResult createWriteResult(BsonDocument result) {
        BsonBoolean updatedExisting = result.getBoolean((Object)"updatedExisting", BsonBoolean.FALSE);
        return WriteConcernResult.acknowledged(result.getNumber((Object)"n", (BsonNumber)new BsonInt32(0)).intValue(), updatedExisting.getValue(), result.get((Object)"upserted"));
    }

    static boolean isCommandOk(BsonDocument response) {
        BsonValue okValue = response.get((Object)"ok");
        return ProtocolHelper.isCommandOk(okValue);
    }

    static boolean isCommandOk(BsonReader bsonReader) {
        return ProtocolHelper.isCommandOk(ProtocolHelper.getField(bsonReader, "ok"));
    }

    private static BsonValue getField(BsonReader bsonReader, String fieldName) {
        bsonReader.readStartDocument();
        while (bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            if (bsonReader.readName().equals(fieldName)) {
                return (BsonValue)REGISTRY.get(BsonValueCodecProvider.getClassForBsonType((BsonType)bsonReader.getCurrentBsonType())).decode(bsonReader, DecoderContext.builder().build());
            }
            bsonReader.skipValue();
        }
        bsonReader.readEndDocument();
        return null;
    }

    private static boolean isCommandOk(BsonValue okValue) {
        if (okValue == null) {
            return false;
        }
        if (okValue.isBoolean()) {
            return okValue.asBoolean().getValue();
        }
        if (okValue.isNumber()) {
            return okValue.asNumber().intValue() == 1;
        }
        return false;
    }

    static MongoException getCommandFailureException(BsonDocument response, ServerAddress serverAddress) {
        MongoException specialException = ProtocolHelper.createSpecialException(response, serverAddress, "errmsg");
        if (specialException != null) {
            return specialException;
        }
        return new MongoCommandException(response, serverAddress);
    }

    static int getErrorCode(BsonDocument response) {
        return response.getNumber((Object)"code", (BsonNumber)new BsonInt32(-1)).intValue();
    }

    static String getErrorMessage(BsonDocument response, String errorMessageFieldName) {
        return response.getString((Object)errorMessageFieldName, new BsonString("")).getValue();
    }

    static MongoException getQueryFailureException(BsonDocument errorDocument, ServerAddress serverAddress) {
        MongoException specialException = ProtocolHelper.createSpecialException(errorDocument, serverAddress, "$err");
        if (specialException != null) {
            return specialException;
        }
        return new MongoQueryException(serverAddress, ProtocolHelper.getErrorCode(errorDocument), ProtocolHelper.getErrorMessage(errorDocument, "$err"));
    }

    static MessageSettings getMessageSettings(ConnectionDescription connectionDescription) {
        return MessageSettings.builder().maxDocumentSize(connectionDescription.getMaxDocumentSize()).maxMessageSize(connectionDescription.getMaxMessageSize()).maxBatchCount(connectionDescription.getMaxBatchCount()).build();
    }

    static RequestMessage encodeMessage(RequestMessage message, BsonOutput bsonOutput) {
        try {
            return message.encode(bsonOutput);
        }
        catch (RuntimeException e) {
            bsonOutput.close();
            throw e;
        }
        catch (Error e) {
            bsonOutput.close();
            throw e;
        }
    }

    private static MongoException createSpecialException(BsonDocument response, ServerAddress serverAddress, String errorMessageFieldName) {
        if (ErrorCategory.fromErrorCode(ProtocolHelper.getErrorCode(response)) == ErrorCategory.EXECUTION_TIMEOUT) {
            return new MongoExecutionTimeoutException(ProtocolHelper.getErrorCode(response), ProtocolHelper.getErrorMessage(response, errorMessageFieldName));
        }
        if (ProtocolHelper.getErrorMessage(response, errorMessageFieldName).startsWith("not master")) {
            return new MongoNotPrimaryException(serverAddress);
        }
        if (ProtocolHelper.getErrorMessage(response, errorMessageFieldName).startsWith("node is recovering")) {
            return new MongoNodeIsRecoveringException(serverAddress);
        }
        return null;
    }

    private static boolean hasWriteError(BsonDocument response) {
        String err = WriteConcernException.extractErrorMessage(response);
        return err != null && err.length() > 0;
    }

    private static void throwWriteException(BsonDocument result, ServerAddress serverAddress) {
        MongoException specialException = ProtocolHelper.createSpecialException(result, serverAddress, "err");
        if (specialException != null) {
            throw specialException;
        }
        int code = WriteConcernException.extractErrorCode(result);
        if (ErrorCategory.fromErrorCode(code) == ErrorCategory.DUPLICATE_KEY) {
            throw new DuplicateKeyException(result, serverAddress, ProtocolHelper.createWriteResult(result));
        }
        throw new WriteConcernException(result, serverAddress, ProtocolHelper.createWriteResult(result));
    }

    static void sendCommandStartedEvent(RequestMessage message, String databaseName, String commandName, BsonDocument command, ConnectionDescription connectionDescription, CommandListener commandListener) {
        block2: {
            try {
                commandListener.commandStarted(new CommandStartedEvent(message.getId(), connectionDescription, databaseName, commandName, command));
            }
            catch (Exception e) {
                if (!PROTOCOL_EVENT_LOGGER.isWarnEnabled()) break block2;
                PROTOCOL_EVENT_LOGGER.warn(String.format("Exception thrown raising command started event to listener %s", commandListener), e);
            }
        }
    }

    static void sendCommandSucceededEvent(RequestMessage message, String commandName, BsonDocument response, ConnectionDescription connectionDescription, long startTimeNanos, CommandListener commandListener) {
        block2: {
            try {
                commandListener.commandSucceeded(new CommandSucceededEvent(message.getId(), connectionDescription, commandName, response, System.nanoTime() - startTimeNanos));
            }
            catch (Exception e) {
                if (!PROTOCOL_EVENT_LOGGER.isWarnEnabled()) break block2;
                PROTOCOL_EVENT_LOGGER.warn(String.format("Exception thrown raising command succeeded event to listener %s", commandListener), e);
            }
        }
    }

    static void sendCommandFailedEvent(RequestMessage message, String commandName, ConnectionDescription connectionDescription, long startTimeNanos, Throwable throwable, CommandListener commandListener) {
        block2: {
            try {
                commandListener.commandFailed(new CommandFailedEvent(message.getId(), connectionDescription, commandName, System.nanoTime() - startTimeNanos, throwable));
            }
            catch (Exception e) {
                if (!PROTOCOL_EVENT_LOGGER.isWarnEnabled()) break block2;
                PROTOCOL_EVENT_LOGGER.warn(String.format("Exception thrown raising command failed event to listener %s", commandListener), e);
            }
        }
    }

    private ProtocolHelper() {
    }
}

