/*
 * Decompiled with CFR 0.152.
 */
package org.rnorth.ansi;

import com.sun.jna.Platform;
import org.rnorth.ansi.CLib;

public class CapabilityDetection {
    private static final int STDOUT_FILENO = 1;

    private CapabilityDetection() {
    }

    public static boolean isUnderIDEA() {
        String classPath = System.getProperty("java.class.path");
        return classPath.contains("idea_rt.jar");
    }

    public static boolean isUnderMaven() {
        return CapabilityDetection.findClass("org.apache.maven.surefire.booter.ForkedBooter") || CapabilityDetection.findClass("org.codehaus.plexus.classworlds.launcher.Launcher");
    }

    private static boolean findClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public static boolean isTty() {
        if (Platform.isWindows()) {
            return false;
        }
        try {
            return CLib.INSTANCE.isatty(1) != 0;
        }
        catch (Throwable ignored) {
            return false;
        }
    }
}

