/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.context;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.context.IContextVariableRestriction;
import org.thymeleaf.context.VariablesMap;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarningContextVariableRestriction
implements IContextVariableRestriction {
    private static final Logger log = LoggerFactory.getLogger(WarningContextVariableRestriction.class);
    private final String targetVariableName;
    private final String message;

    public WarningContextVariableRestriction(String targetVariableName) {
        this(targetVariableName, null);
    }

    public WarningContextVariableRestriction(String targetVariableName, String message) {
        Validate.notNull(targetVariableName, "Variable name cannot be null");
        this.targetVariableName = targetVariableName;
        this.message = message;
    }

    @Override
    public void checkAccess(VariablesMap<?, ?> variablesMap, String variableName) {
        if (!this.targetVariableName.equals(variableName)) {
            return;
        }
        String warningMessage = this.message != null ? this.message : "Variable \"" + variableName + "\" has been accessed, which raises a warning in this context";
        log.warn(warningMessage);
    }
}

