/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.thymeleaf.context.VariablesMap;
import org.thymeleaf.context.WebRequestParamsVariablesMap;
import org.thymeleaf.context.WebServletContextVariablesMap;
import org.thymeleaf.context.WebSessionVariablesMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WebVariablesMap
extends VariablesMap<String, Object> {
    private static final long serialVersionUID = 3862067921983550180L;
    public static final String PARAM_VARIABLE_NAME = "param";
    public static final String SESSION_VARIABLE_NAME = "session";
    public static final String APPLICATION_VARIABLE_NAME = "application";
    private final HttpServletRequest request;
    private final ServletContext servletContext;
    private final WebRequestParamsVariablesMap requestParamsVariablesMap;
    private final WebSessionVariablesMap sessionVariablesMap;
    private final WebServletContextVariablesMap servletContextVariablesMap;
    private boolean evalSelectionTargetPresent = false;

    WebVariablesMap(HttpServletRequest request, ServletContext servletContext, Map<? extends String, ?> m) {
        super(m == null ? 4 : m.size() + 4, 1.0f);
        this.request = request;
        this.servletContext = servletContext;
        this.requestParamsVariablesMap = new WebRequestParamsVariablesMap(this.request);
        this.sessionVariablesMap = new WebSessionVariablesMap(this.request);
        this.servletContextVariablesMap = new WebServletContextVariablesMap(this.servletContext);
        super.put(APPLICATION_VARIABLE_NAME, this.servletContextVariablesMap);
        super.put(PARAM_VARIABLE_NAME, this.requestParamsVariablesMap);
        super.put(SESSION_VARIABLE_NAME, this.sessionVariablesMap);
        if (m != null) {
            this.putAll((Map<? extends String, ?>)m);
        }
        if (!this.evalSelectionTargetPresent) {
            Enumeration attributeNames = this.request.getAttributeNames();
            while (attributeNames.hasMoreElements()) {
                if (!"%%{SELECTION_TARGET}%%".equals(attributeNames.nextElement())) continue;
                this.evalSelectionTargetPresent = true;
                break;
            }
        }
    }

    public WebRequestParamsVariablesMap getRequestParamsVariablesMap() {
        return this.requestParamsVariablesMap;
    }

    public WebSessionVariablesMap getSessionVariablesMap() {
        return this.sessionVariablesMap;
    }

    public WebServletContextVariablesMap getServletContextVariablesMap() {
        return this.servletContextVariablesMap;
    }

    @Override
    public int size() {
        int size = 3;
        Enumeration attributeNames = this.request.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            attributeNames.nextElement();
            ++size;
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Object get(Object key) {
        if (WebVariablesMap.isReservedVariableName((String)key)) {
            return super.get(key);
        }
        return this.request.getAttribute((String)key);
    }

    @Override
    public boolean containsKey(Object key) {
        if (WebVariablesMap.isReservedVariableName((String)key)) {
            return true;
        }
        if ("%%{SELECTION_TARGET}%%".equals(key)) {
            return this.evalSelectionTargetPresent;
        }
        Enumeration attributeNames = this.request.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attributeName = (String)attributeNames.nextElement();
            if (!(key == null ? attributeName == null : key.equals(attributeName))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object put(String key, Object value) {
        if (WebVariablesMap.isReservedVariableName(key)) {
            throw new IllegalArgumentException("Putting a context variable with name \"" + key + "\" is forbidden, as it is a reserved variable name.");
        }
        if ("%%{SELECTION_TARGET}%%".equals(key)) {
            this.evalSelectionTargetPresent = true;
        }
        this.request.setAttribute(key, value);
        return value;
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        for (Map.Entry<String, ?> mEntry : m.entrySet()) {
            this.put(mEntry.getKey(), mEntry.getValue());
        }
    }

    @Override
    public Object remove(Object key) {
        if (WebVariablesMap.isReservedVariableName((String)key)) {
            throw new IllegalArgumentException("Removing context variable \"" + key + "\" is forbidden, as it is a reserved variable name.");
        }
        if ("%%{SELECTION_TARGET}%%".equals(key)) {
            this.evalSelectionTargetPresent = false;
        }
        Object value = this.request.getAttribute((String)key);
        this.request.removeAttribute((String)key);
        return value;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Web variable context map cannot be completely cleared.");
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof VariablesMap && (value == this.requestParamsVariablesMap || value == this.sessionVariablesMap || value == this.servletContextVariablesMap)) {
            return true;
        }
        Enumeration attributeNames = this.request.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attributeName = (String)attributeNames.nextElement();
            Object attributeValue = this.request.getAttribute(attributeName);
            if (!(value == null ? attributeValue == null : value.equals(attributeValue))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keySet = new HashSet<String>(10);
        Enumeration attributeNames = this.request.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            keySet.add((String)attributeNames.nextElement());
        }
        keySet.addAll(super.keySet());
        return keySet;
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> values = new ArrayList<Object>(10);
        Enumeration attributeNames = this.request.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attributeName = (String)attributeNames.nextElement();
            values.add(this.request.getAttribute(attributeName));
        }
        values.addAll(super.values());
        return values;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        Map<String, Object> attributeMap = WebVariablesMap.getAttributeMap(this.request);
        for (Map.Entry superEntry : super.entrySet()) {
            attributeMap.put((String)superEntry.getKey(), superEntry.getValue());
        }
        return attributeMap.entrySet();
    }

    @Override
    public String toString() {
        Map<String, Object> attributeMap = WebVariablesMap.getAttributeMap(this.request);
        for (Map.Entry superEntry : super.entrySet()) {
            attributeMap.put((String)superEntry.getKey(), superEntry.getValue());
        }
        return attributeMap.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.request.hashCode();
        result = 31 * result + this.servletContext.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WebVariablesMap other = (WebVariablesMap)obj;
        if (this.request == null ? other.request != null : !this.request.equals(other.request)) {
            return false;
        }
        return !(this.servletContext == null ? other.servletContext != null : !this.servletContext.equals(other.servletContext));
    }

    private static Map<String, Object> getAttributeMap(HttpServletRequest request) {
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        Enumeration attributeNames = request.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attributeName = (String)attributeNames.nextElement();
            Object attributeValue = request.getAttribute(attributeName);
            attributeMap.put(attributeName, attributeValue);
        }
        return attributeMap;
    }

    private static boolean isReservedVariableName(String name) {
        return PARAM_VARIABLE_NAME.equals(name) || SESSION_VARIABLE_NAME.equals(name) || APPLICATION_VARIABLE_NAME.equals(name);
    }

    @Override
    public WebVariablesMap clone() {
        return (WebVariablesMap)super.clone();
    }
}

