/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.resourceresolver;

import java.io.InputStream;
import javax.servlet.ServletContext;
import org.thymeleaf.TemplateProcessingParameters;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.resourceresolver.IResourceResolver;
import org.thymeleaf.util.Validate;

public final class ServletContextResourceResolver
implements IResourceResolver {
    public static final String NAME = "SERVLETCONTEXT";

    public String getName() {
        return NAME;
    }

    public InputStream getResourceAsStream(TemplateProcessingParameters templateProcessingParameters, String resourceName) {
        Validate.notNull(templateProcessingParameters, "Template Processing Parameters cannot be null");
        Validate.notNull(resourceName, "Resource name cannot be null");
        IContext context = templateProcessingParameters.getContext();
        if (!(context instanceof IWebContext)) {
            throw new TemplateProcessingException("Resource resolution by ServletContext with " + this.getClass().getName() + " can only be performed when context implements " + IWebContext.class.getName() + " [current context: " + context.getClass().getName() + "]");
        }
        ServletContext servletContext = ((IWebContext)context).getServletContext();
        if (servletContext == null) {
            throw new TemplateProcessingException("Thymeleaf context returned a null ServletContext");
        }
        return servletContext.getResourceAsStream(resourceName);
    }
}

