/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.io.Serializable;
import org.thymeleaf.Configuration;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.ComplexExpression;
import org.thymeleaf.standard.expression.ExpressionParsingDecompositionConfig;
import org.thymeleaf.standard.expression.ExpressionParsingNode;
import org.thymeleaf.standard.expression.ExpressionParsingState;
import org.thymeleaf.standard.expression.ExpressionParsingUtil;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.IStandardVariableExpressionEvaluator;
import org.thymeleaf.standard.expression.LiteralValue;
import org.thymeleaf.standard.expression.SimpleExpression;
import org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.util.Validate;

public abstract class Expression
implements IStandardExpression,
Serializable {
    private static final long serialVersionUID = 1608378943284014151L;
    public static final char PARSING_PLACEHOLDER_CHAR = '\u00a7';
    public static final char NESTING_START_CHAR = '(';
    public static final char NESTING_END_CHAR = ')';

    protected Expression() {
    }

    public abstract String getStringRepresentation();

    public String toString() {
        return this.getStringRepresentation();
    }

    static Expression parse(String input) {
        Validate.notNull(input, "Input cannot be null");
        ExpressionParsingState decomposition = ExpressionParsingUtil.decompose(input, ExpressionParsingDecompositionConfig.DECOMPOSE_ALL_AND_UNNEST);
        if (decomposition == null) {
            return null;
        }
        ExpressionParsingState result = ExpressionParsingUtil.compose(decomposition);
        if (result == null || !result.hasExpressionAt(0)) {
            return null;
        }
        return ((ExpressionParsingNode)result.get(0)).getExpression();
    }

    static Object execute(Configuration configuration, IProcessingContext processingContext, Expression expression, IStandardVariableExpressionEvaluator expressionEvaluator, StandardExpressionExecutionContext expContext) {
        if (expression instanceof SimpleExpression) {
            return SimpleExpression.executeSimple(configuration, processingContext, (SimpleExpression)expression, expressionEvaluator, expContext);
        }
        if (expression instanceof ComplexExpression) {
            return ComplexExpression.executeComplex(configuration, processingContext, (ComplexExpression)expression, expContext);
        }
        throw new TemplateProcessingException("Unrecognized expression: " + expression.getClass().getName());
    }

    public Object execute(Configuration configuration, IProcessingContext processingContext) {
        return this.execute(configuration, processingContext, StandardExpressionExecutionContext.NORMAL);
    }

    public Object execute(Configuration configuration, IProcessingContext processingContext, StandardExpressionExecutionContext expContext) {
        Validate.notNull(configuration, "Configuration cannot be null");
        Validate.notNull(processingContext, "Processing context cannot be null");
        IStandardVariableExpressionEvaluator variableExpressionEvaluator = StandardExpressions.getVariableExpressionEvaluator(configuration);
        Object result = Expression.execute(configuration, processingContext, this, variableExpressionEvaluator, expContext);
        return LiteralValue.unwrap(result);
    }
}

