/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.processor.attr;

import java.util.HashMap;
import java.util.Map;
import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.dom.Element;
import org.thymeleaf.processor.IAttributeNameProcessorMatcher;
import org.thymeleaf.processor.attr.AbstractLocalVariableDefinitionAttrProcessor;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.StandardExpressions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStandardSwitchStructureAttrProcessor
extends AbstractLocalVariableDefinitionAttrProcessor {
    public static final String SWITCH_VARIABLE_NAME = "[%SWITCH_EXPR%]";

    protected AbstractStandardSwitchStructureAttrProcessor(IAttributeNameProcessorMatcher matcher) {
        super(matcher);
    }

    protected AbstractStandardSwitchStructureAttrProcessor(String attributeName) {
        super(attributeName);
    }

    @Override
    protected final Map<String, Object> getNewLocalVariables(Arguments arguments, Element element, String attributeName) {
        String attributeValue = element.getAttributeValue(attributeName);
        Configuration configuration = arguments.getConfiguration();
        IStandardExpressionParser expressionParser = StandardExpressions.getExpressionParser(configuration);
        IStandardExpression switchExpression = expressionParser.parseExpression(configuration, arguments, attributeValue);
        HashMap<String, Object> newVariables = new HashMap<String, Object>(2, 1.0f);
        newVariables.put(SWITCH_VARIABLE_NAME, new SwitchStructure(switchExpression));
        return newVariables;
    }

    public static final class SwitchStructure {
        private final IStandardExpression expression;
        private boolean executed;

        public SwitchStructure(IStandardExpression expression) {
            this.expression = expression;
            this.executed = false;
        }

        public IStandardExpression getExpression() {
            return this.expression;
        }

        public boolean isExecuted() {
            return this.executed;
        }

        public void setExecuted(boolean executed) {
            this.executed = executed;
        }
    }
}

