/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.processor.text;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.dom.AbstractTextNode;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.processor.TextNodeProcessorMatcher;
import org.thymeleaf.processor.document.ProcessAllNodesDocumentProcessor;
import org.thymeleaf.processor.text.AbstractTextNodeProcessor;
import org.thymeleaf.standard.inliner.IStandardTextInliner;

public final class StandardTextInliningTextProcessor
extends AbstractTextNodeProcessor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final int ATTR_PRECEDENCE = 100;
    public static final TextNodeProcessorMatcher MATCHER = new TextNodeProcessorMatcher();

    public StandardTextInliningTextProcessor() {
        super(new TextNodeProcessorMatcher());
    }

    public int getPrecedence() {
        return 100;
    }

    public ProcessorResult processTextNode(Arguments arguments, AbstractTextNode textNode) {
        if (!textNode.getProcessTextNodes()) {
            throw new TemplateProcessingException("Cannot execute text inlining processor: Text processors are not active");
        }
        Object inliner = arguments.getLocalVariable("%STANDARD_INLINER%");
        if (inliner == null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("[THYMELEAF][{}][{}] Will not process Text node as inline: no inliner has been set. Please note that setting the 'processOnlyElementNodes' flag to false at a high level in the DOM tree (like for example using " + ProcessAllNodesDocumentProcessor.class.getName() + ") can reduce processing performance in templates with a big amount of Text nodes. Consider setting this flag back to true at some point in your DOM tree to reduce this effect.", new Object[]{TemplateEngine.threadIndex(), arguments.getTemplateName()});
            }
            return ProcessorResult.OK;
        }
        if (!(inliner instanceof IStandardTextInliner)) {
            throw new TemplateProcessingException("Cannot execute text inlining processor: Inliner set does not implement " + IStandardTextInliner.class.getName() + " (it is an object of class " + inliner.getClass().getName() + ")");
        }
        ((IStandardTextInliner)inliner).inline(arguments, textNode);
        return ProcessorResult.OK;
    }
}

