/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.templateparser.xmldom;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Configuration;
import org.thymeleaf.dom.Document;
import org.thymeleaf.dom.Node;
import org.thymeleaf.exceptions.ParserInitializationException;
import org.thymeleaf.exceptions.TemplateInputException;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.templateparser.EntityResolver;
import org.thymeleaf.templateparser.ErrorHandler;
import org.thymeleaf.templateparser.ITemplateParser;
import org.thymeleaf.templateparser.TemplatePreprocessingReader;
import org.thymeleaf.util.ResourcePool;
import org.thymeleaf.util.StandardDOMTranslator;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public abstract class AbstractNonValidatingDOMTemplateParser
implements ITemplateParser {
    private static final int BUFFER_SIZE = 8192;
    private static final String SAXPARSEEXCEPTION_BAD_ELEMENT_CONTENT = "The content of elements must consist of well-formed character data or markup.";
    private static final String SAXPARSEEXCEPTION_BAD_ELEMENT_CONTENT_EXPLANATION = "The content of elements must consist of well-formed character data or markup. A usual reason for this is that one of your elements contains unescaped special XML symbols like '<' inside its body, which is forbidden by XML rules. For example, if you have '<' inside a <script> tag, you should surround your script body with commented CDATA markers (like '/* <![CDATA[ */' and '/* ]]> */')";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ResourcePool<DocumentBuilder> pool;
    private boolean canResetParsers = true;

    protected AbstractNonValidatingDOMTemplateParser(int poolSize) {
        this.pool = this.createDocumentBuilders(poolSize, false);
    }

    protected ResourcePool<DocumentBuilder> getPool() {
        return this.pool;
    }

    protected final ResourcePool<DocumentBuilder> getNonValidatingPool() {
        return this.pool;
    }

    protected final ResourcePool<DocumentBuilder> createDocumentBuilders(int poolSize, boolean validating) {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setValidating(validating);
        return new ResourcePool<DocumentBuilder>(new DOMTemplateParserFactory(docBuilderFactory), poolSize);
    }

    @Override
    public final Document parseTemplate(Configuration configuration, String documentName, Reader reader) {
        return this.parseTemplateUsingPool(configuration, documentName, reader, this.getPool());
    }

    protected final Document parseTemplateUsingPool(Configuration configuration, String documentName, Reader reader, ResourcePool<DocumentBuilder> poolToBeUsed) {
        DocumentBuilder docBuilder = poolToBeUsed.allocate();
        TemplatePreprocessingReader templateReader = this.getTemplatePreprocessingReader(reader);
        try {
            docBuilder.setEntityResolver(new EntityResolver(configuration));
            docBuilder.setErrorHandler(ErrorHandler.INSTANCE);
            org.w3c.dom.Document domDocument = docBuilder.parse(new InputSource(templateReader));
            if (this.canResetParsers) {
                try {
                    docBuilder.reset();
                }
                catch (UnsupportedOperationException ignored) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn("[THYMELEAF] The DOM Parser implementation being used (\"{}\") does not implement the \"reset\" operation. This will force Thymeleaf to re-create parser instances each time they are needed for parsing templates, which is more costly. Enabling template cache is recommended, and also using a parser library which implements \"reset\" such as xerces version 2.9.1 or newer.", (Object)docBuilder.getClass().getName());
                    }
                    this.canResetParsers = false;
                }
            }
            Document document = StandardDOMTranslator.translateDocument(domDocument, documentName, templateReader.getDocTypeClause());
            return document;
        }
        catch (SAXException e) {
            if (e.getMessage() != null && e.getMessage().contains(SAXPARSEEXCEPTION_BAD_ELEMENT_CONTENT)) {
                throw new TemplateInputException(SAXPARSEEXCEPTION_BAD_ELEMENT_CONTENT_EXPLANATION, e);
            }
            throw new TemplateInputException("An exception happened during parsing", e);
        }
        catch (IOException e) {
            throw new TemplateInputException("Exception parsing document", e);
        }
        catch (TemplateProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TemplateInputException("Exception parsing document", e);
        }
        finally {
            if (templateReader != null) {
                try {
                    templateReader.close();
                }
                catch (Exception exception) {}
            }
            if (this.canResetParsers) {
                poolToBeUsed.release(docBuilder);
            } else {
                poolToBeUsed.discardAndReplace(docBuilder);
            }
        }
    }

    @Override
    public final List<Node> parseFragment(Configuration configuration, String fragment) {
        String wrappedFragment = this.wrapFragment(fragment);
        Document document = this.parseTemplateUsingPool(configuration, null, new StringReader(wrappedFragment), this.getNonValidatingPool());
        return this.unwrapFragment(document);
    }

    protected abstract String wrapFragment(String var1);

    protected abstract List<Node> unwrapFragment(Document var1);

    protected boolean shouldAddThymeleafRootToParser() {
        return true;
    }

    protected TemplatePreprocessingReader getTemplatePreprocessingReader(Reader reader) {
        if (reader instanceof TemplatePreprocessingReader) {
            TemplatePreprocessingReader templatePreprocessingReader = (TemplatePreprocessingReader)reader;
            return new TemplatePreprocessingReader(templatePreprocessingReader.getInnerReader(), 8192, this.shouldAddThymeleafRootToParser());
        }
        return new TemplatePreprocessingReader(reader, 8192, this.shouldAddThymeleafRootToParser());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DOMTemplateParserFactory
    implements ResourcePool.IResourceFactory<DocumentBuilder> {
        private final DocumentBuilderFactory docBuilderFactory;

        DOMTemplateParserFactory(DocumentBuilderFactory docBuilderFactory) {
            this.docBuilderFactory = docBuilderFactory;
        }

        @Override
        public DocumentBuilder createResource() {
            try {
                return this.docBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new ParserInitializationException("Error creating document builder", e);
            }
        }
    }
}

