/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.templateresolver;

import java.util.regex.Pattern;
import org.thymeleaf.TemplateProcessingParameters;
import org.thymeleaf.exceptions.ConfigurationException;
import org.thymeleaf.resourceresolver.IResourceResolver;
import org.thymeleaf.resourceresolver.UrlResourceResolver;
import org.thymeleaf.templateresolver.ITemplateResolutionValidity;
import org.thymeleaf.templateresolver.NonCacheableTemplateResolutionValidity;
import org.thymeleaf.templateresolver.TemplateResolver;

public class UrlTemplateResolver
extends TemplateResolver {
    private static final Pattern JSESSIONID_PATTERN = Pattern.compile("(.*?);jsessionid(.*?)");

    public UrlTemplateResolver() {
        super.setResourceResolver(new UrlResourceResolver());
    }

    public void setResourceResolver(IResourceResolver resourceResolver) {
        throw new ConfigurationException("Cannot set a resource resolver on " + this.getClass().getName() + ". If you want to set your own resource resolver, use " + TemplateResolver.class.getName() + "instead");
    }

    protected ITemplateResolutionValidity computeValidity(TemplateProcessingParameters templateProcessingParameters) {
        String templateName = templateProcessingParameters.getTemplateName();
        if (JSESSIONID_PATTERN.matcher(templateName.toLowerCase()).matches()) {
            return NonCacheableTemplateResolutionValidity.INSTANCE;
        }
        return super.computeValidity(templateProcessingParameters);
    }
}

