// Copyright (c) 1998 by W3C
//
// DOM is a trademark of W3C
// The DOM level 1 specification, from which this
// source is derived, is copyright by W3C.
// See: http://www.w3.org/TR/REC-DOM-Level-1/
//

package org.w3c.dom;

/**
<P>CDATA sections are used to escape blocks of text containing 
	characters that would otherwise be regarded as markup. The only 
	delimiter that is recognized in a CDATA section is the "]]&gt;" string 
	that ends the CDATA section. CDATA sections can not be 
	nested. The primary purpose is for including
      material such as XML fragments, without needing to escape all
      the delimiters.
<P>The <code>data</code> attribute of the
      <A HREF='Text.html'><CODE>Text</CODE></A> node holds the text that is contained by the CDATA
      section. Note that this <emph>may</emph> contain characters
      that need to be escaped outside of CDATA sections and that, depending on
      the character encoding ("charset") chosen for serialization, it may be
      impossible to write out some characters as part of a CDATA section.
<P> The <A HREF='CDATASection.html'><CODE>CDATASection</CODE></A> interface inherits the
      <A HREF='CharacterData.html'><CODE>CharacterData</CODE></A> interface through the <A HREF='Text.html'><CODE>Text</CODE></A>
      interface. Adjacent <code>CDATASections</code> nodes are not merged by
      use of the Element.normalize() method.

*/
public interface CDATASection
extends Text
{
}
