// Copyright (c) 1998 by W3C
//
// DOM is a trademark of W3C
// The DOM level 1 specification, from which this
// source is derived, is copyright by W3C.
// See: http://www.w3.org/TR/REC-DOM-Level-1/
//

package org.w3c.dom.html;

import org.w3c.dom.*;

/**

  <P>The create* and delete* methods on the table allow authors to construct and modify tables. HTML 4.0 specifies that only one of each of the 
    <code>CAPTION</code>, 
    <code>THEAD</code>, and 
    <code>TFOOT</code>
elements may exist in a table. Therefore, if one exists, and the createTHead() or createTFoot() method is called, the method returns the existing THead or TFoot element. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/tables.html#edef-TABLE">TABLE element definition</A>
 in HTML 4.0.
  
</P>

<HR>

<!-- ======== PROPERTY SUMMARY ======== -->

<A NAME="property_summary"><!-- --></A>
<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>
<TR BGCOLOR=#CCCCFF ID=TableHeadingColor>
<TD COLSPAN=3><FONT SIZE=+2><B>Property Summary</B>
</FONT></TD></TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-caption><CODE>&nbsp;caption</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getCaption()'>getCaption</a>
<a href='#setCaption(java.lang.String)'>setCaption</a>
</TD>
<TD>
  <P>Returns the table's 
    <code>CAPTION</code>, or void if none exists. 
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-tHead><CODE>&nbsp;tHead</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getTHead()'>getTHead</a>
<a href='#setTHead(java.lang.String)'>setTHead</a>
</TD>
<TD>
  <P>Returns the table's 
    <code>THEAD</code>, or 
    <code>null</code> if none exists. 
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-tFoot><CODE>&nbsp;tFoot</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getTFoot()'>getTFoot</a>
<a href='#setTFoot(java.lang.String)'>setTFoot</a>
</TD>
<TD>
  <P>Returns the table's 
    <code>TFOOT</code>, or 
    <code>null</code> if none exists. 
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-rows><CODE>&nbsp;rows</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getRows()'>getRows</a>
</TD>
<TD>
  <P>Returns a collection of all the rows in the table, including all in 
    <code>THEAD</code>, 
    <code>TFOOT</code>, all 
    <code>TBODY</code> elements. 
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-tBodies><CODE>&nbsp;tBodies</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getTBodies()'>getTBodies</a>
</TD>
<TD>
  <P>Returns a collection of the defined table bodies. 
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-align><CODE>&nbsp;align</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getAlign()'>getAlign</a>
<a href='#setAlign(java.lang.String)'>setAlign</a>
</TD>
<TD>
  <P>Specifies the table's position with respect to the rest of the document. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-align-TABLE">align attribute definition</A>
 in HTML 4.0. This attribute is deprecated in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-bgColor><CODE>&nbsp;bgColor</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getBgColor()'>getBgColor</a>
<a href='#setBgColor(java.lang.String)'>setBgColor</a>
</TD>
<TD>
  <P>Cell background color. See the 
    <A  href="http://www.w3.org/TR/REC-html40/present/graphics.html#adef-bgcolor">bgcolor attribute definition</A>
 in HTML 4.0. This attribute is deprecated in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-border><CODE>&nbsp;border</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getBorder()'>getBorder</a>
<a href='#setBorder(java.lang.String)'>setBorder</a>
</TD>
<TD>
  <P>The width of the border around the table. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-border-TABLE">border attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-cellPadding><CODE>&nbsp;cellPadding</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getCellPadding()'>getCellPadding</a>
<a href='#setCellPadding(java.lang.String)'>setCellPadding</a>
</TD>
<TD>
  <P>Specifies the horizontal and vertical space between cell content and cell borders. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-cellpadding">cellpadding attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-cellSpacing><CODE>&nbsp;cellSpacing</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getCellSpacing()'>getCellSpacing</a>
<a href='#setCellSpacing(java.lang.String)'>setCellSpacing</a>
</TD>
<TD>
  <P>Specifies the horizontal and vertical separation between cells. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-cellspacing">cellspacing attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-frame><CODE>&nbsp;frame</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getFrame()'>getFrame</a>
<a href='#setFrame(java.lang.String)'>setFrame</a>
</TD>
<TD>
  <P>Specifies which external table borders to render. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-frame">frame attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-rules><CODE>&nbsp;rules</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getRules()'>getRules</a>
<a href='#setRules(java.lang.String)'>setRules</a>
</TD>
<TD>
  <P>Specifies which internal table borders to render. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-rules">rules attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-summary><CODE>&nbsp;summary</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getSummary()'>getSummary</a>
<a href='#setSummary(java.lang.String)'>setSummary</a>
</TD>
<TD>
  <P>Supplementary description about the purpose or structure of a table. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-summary">summary attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-width><CODE>&nbsp;width</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getWidth()'>getWidth</a>
<a href='#setWidth(java.lang.String)'>setWidth</a>
</TD>
<TD>
  <P>Specifies the desired table width. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-width-TABLE">width attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
</TABLE>
&nbsp;
*/
public interface HTMLTableElement
extends HTMLElement
{
	/** Assigns the value of the <code><a href=#att-caption>caption</a></code> property.
	 */
	void setCaption (HTMLTableCaptionElement caption);

	/**
	 * Returns the value of the <code><a href=#att-caption>caption</a></code> property.
	*/
	HTMLTableCaptionElement getCaption ();


	/** Assigns the value of the <code><a href=#att-tHead>tHead</a></code> property.
	 */
	void setTHead (HTMLTableSectionElement tHead);

	/**
	 * Returns the value of the <code><a href=#att-tHead>tHead</a></code> property.
	*/
	HTMLTableSectionElement getTHead ();


	/** Assigns the value of the <code><a href=#att-tFoot>tFoot</a></code> property.
	 */
	void setTFoot (HTMLTableSectionElement tFoot);

	/**
	 * Returns the value of the <code><a href=#att-tFoot>tFoot</a></code> property.
	*/
	HTMLTableSectionElement getTFoot ();


	/**
	 * Returns the value of the <code><a href=#att-rows>rows</a></code> property.
	*/
	HTMLCollection getRows ();


	/**
	 * Returns the value of the <code><a href=#att-tBodies>tBodies</a></code> property.
	*/
	HTMLCollection getTBodies ();


	/** Assigns the value of the <code><a href=#att-align>align</a></code> property.
	 */
	void setAlign (String align);

	/**
	 * Returns the value of the <code><a href=#att-align>align</a></code> property.
	*/
	String getAlign ();


	/** Assigns the value of the <code><a href=#att-bgColor>bgColor</a></code> property.
	 */
	void setBgColor (String bgColor);

	/**
	 * Returns the value of the <code><a href=#att-bgColor>bgColor</a></code> property.
	*/
	String getBgColor ();


	/** Assigns the value of the <code><a href=#att-border>border</a></code> property.
	 */
	void setBorder (String border);

	/**
	 * Returns the value of the <code><a href=#att-border>border</a></code> property.
	*/
	String getBorder ();


	/** Assigns the value of the <code><a href=#att-cellPadding>cellPadding</a></code> property.
	 */
	void setCellPadding (String cellPadding);

	/**
	 * Returns the value of the <code><a href=#att-cellPadding>cellPadding</a></code> property.
	*/
	String getCellPadding ();


	/** Assigns the value of the <code><a href=#att-cellSpacing>cellSpacing</a></code> property.
	 */
	void setCellSpacing (String cellSpacing);

	/**
	 * Returns the value of the <code><a href=#att-cellSpacing>cellSpacing</a></code> property.
	*/
	String getCellSpacing ();


	/** Assigns the value of the <code><a href=#att-frame>frame</a></code> property.
	 */
	void setFrame (String frame);

	/**
	 * Returns the value of the <code><a href=#att-frame>frame</a></code> property.
	*/
	String getFrame ();


	/** Assigns the value of the <code><a href=#att-rules>rules</a></code> property.
	 */
	void setRules (String rules);

	/**
	 * Returns the value of the <code><a href=#att-rules>rules</a></code> property.
	*/
	String getRules ();


	/** Assigns the value of the <code><a href=#att-summary>summary</a></code> property.
	 */
	void setSummary (String summary);

	/**
	 * Returns the value of the <code><a href=#att-summary>summary</a></code> property.
	*/
	String getSummary ();


	/** Assigns the value of the <code><a href=#att-width>width</a></code> property.
	 */
	void setWidth (String width);

	/**
	 * Returns the value of the <code><a href=#att-width>width</a></code> property.
	*/
	String getWidth ();


/**

  <P>Create a table header row or return an existing one.
</P>

@return A new table header element (
  <code>THEAD</code>).

*/
HTMLElement createTHead ();

/**

  <P>Delete the header from the table, if one exists.
</P>

*/
void deleteTHead ();

/**

  <P>Create a table footer row or return an existing one.
</P>

@return A footer element (
  <code>TFOOT</code>).

*/
HTMLElement createTFoot ();

/**

  <P>Delete the footer from the table, if one exists.
</P>

*/
void deleteTFoot ();

/**

  <P>Create a new table caption object or return an existing one.
</P>

@return A 
  <code>CAPTION</code> element.

*/
HTMLElement createCaption ();

/**

  <P>Delete the table caption, if one exists.
</P>

*/
void deleteCaption ();

/**

  <P>Insert a new empty row in the table. 
    <emph>Note.</emph> A table row cannot be empty according to HTML 4.0 Recommendation. 
  
</P>

@return The newly created row.
@param index
The row number where to insert a new row.
*/
HTMLElement insertRow (int index);

/**

  <P>Delete a table row.
</P>

@param index
The index of the row to be deleted.
*/
void deleteRow (int index);

}
